/*
Inserts a newline and indents it one level at the user's cursor
*/

action.performWithContext = function(context, outError) {
	// Grab the cursor/selection position
	var range = context.selectedRanges[0];
	var wrappedIndent = false;
	// Grab the line to see if there's any content after the cursor/selection
	var linerange = context.lineStorage.lineRangeForIndex(range.location + range.length);
	// Only proceed if the line doesn't start with the end of the selection (because if that's the case, we got the following line and our cursor terminates at the end of the current line)
	if (linerange.location < range.location + range.length) {
		var trailingRange = new Range(range.location + range.length, linerange.length - range.length - (range.location - linerange.location));
		var trailingChars = context.string.substringWithRange(trailingRange);
		if (trailingChars.length > 0) {
			// We have some characters; strip out any leading whitespace to make sure there's something worth indenting
			trailingChars = trailingChars.replace(/^\s+(.*)$/, '$1');
			if (trailingChars.length > 0) {
				// Not just whitespace, so we need to wrap our indented line
				wrappedIndent = true;
			}
		}
	}
	
	// Create our snippet, and insert!
	var snippet = '\n\t${1:$EDITOR_SELECTION}';
	if (wrappedIndent) {
		// We have trailing characters in this line, so add a linebreak
		snippet += '\n';
	}
	snippet = new CETextSnippet(snippet);
	return context.insertTextSnippet(snippet);
};